#!/usr/bin/perl -w
#========================================================================
# Reads your source list and creates the NRT proposal requested time table.
# Also creates the source list table(s).
#
# version by JMM - June, Aug. 2007. V.0.6 30 August
#
# use   :   ./requestTable6.pl inputFile
#           (first chmod +x  the script!)
# syntax:   ! for comments in the input file
#
# Example of input file:
#! ce sont les 3 lignes de commentaire.
#! Ensuite suivent les lignes de donnees au format suivant
#! nom  alpha        delta       REQTIME
#NGC123 12 3O 22.234 55 43 21.23 4 
#PCG0123123 11 11 00.01 0 0 1. 10 10
#
# Possible modification: change below the $choice variable initialization
# to put zeros or space characters in the table (when no time asked for
# in some R.A. bins).
#========================================================================
use strict; use warnings;
my @line ; my @name; my @reqIntTime; my @reqObsNumber; my @decSign;
my @rahh ; my @ramm; my @rass ;
my @decdd;my @decmm; my @decss;
my $i=0  ; 
#my $choice="zeros";    # To keep zeros in the req. time table
my $choice="spaces";   #To put space characters instead of zeros 
                       # in the RA sorted table.
my @table;             # Initialization of the array.
for ($i=0; $i<72; $i++){
    $table[$i]=0;
}
$i=0;
print "\n>>>>>>> Welcome to the $0 Perl script <<<<<<<<\n\n";
while (<>) {           # read input 
    if (/^\!/) {       # check for comments (anywhere in file)
	print;}        #                    print them
    else {
	$i++;
	&decodeLine(); # process one input line at a time
	&addForTable();
	}
}
&makeTable();
&makeList();

sub decodeLine{
    @line = split; # split the data line
    $name[$i] = $line[0]; 
    $rahh[$i] = $line[1];$ramm[$i] = $line[2];$rass[$i] = $line[3];
    $decdd[$i] =$line[4];$decmm[$i] =$line[5];$decss[$i] =$line[6];
    $reqIntTime[$i] = $line[7];
    if ($decdd[$i] =~ /^-./) {
	$decSign[$i]="negative" ;
	print "negative dec in $name[$i] (debug)";
    }
    print "> Source: ",$line[0],"\n";
    my $declination=$decdd[$i];

    if ($rahh[$i]>23 || $ramm[$i]>60 || $rass[$i]>60 || $decdd[$i]<-40 || $decdd[$i]>90 || $decmm[$i]>60 || $decss[$i]>60) {
	    print "@line\n";
	    die "Coordinate problem for source $name[$i]\n\n";}
}

sub addForTable{
    my $index; my $ra;
    $ra=$rahh[$i]+$ramm[$i]/60;
    $index=int($ra/0.3333);
    # This procedure is made to fill the NRT Obs Time Request form.
    # One single target, which can be observed for 1 hour or more depending
    # on its declination, appears for n 'days' of requested observations
    # which correspond to n requested hours. Each single observation is,
    # at this point, supposed to last 1 hour.
    $table[$index]=$table[$index]+$reqIntTime[$i];
    print "$ra\n";
    print "$index \n","$reqIntTime[$i]\n" ;
}

sub lisTable{
    #for debugging only.
    for (my $ia=0; $ia<72; $ia++){
      print "$ia $table[$ia]\n"; }
}

sub makeTable{
    # Creates the LaTex include file for the sorted time request table
    # To be included in the LaTeX NRT proposal form.
    my $s1=" & "; my $s2=":"; my $s3="\\"; my $hl="\\hline\n";
    my $a=0; my $totTime=0;
    my $updateTotTime1="Please update the Total Requested Time field in the LaTeX proposal:\n";
    my $updateTotTime2="Total amount of observation time requested in the Table = ";

    open (FORMOUT, '> RAsortedTable.tex') || die "Problem with output file in sub makeTable()";
    print FORMOUT $hl;
    print FORMOUT "\\textbf{R.A.}&\\textbf{0h}&\\textbf{1h}&\\textbf{2h}&\\textbf{3h}&\\textbf{4h}","\n","&\\textbf{5h}&\\textbf{6h}&\\textbf{7h}&\\textbf{8h}& \\textbf{9h}&\\textbf{10h}&\\textbf{11h} \\","\\","\n";
    print FORMOUT "\% RA bin & 0 & 1 & 2 & 3 & 4 & 5 & 6 & 7 & 8 & 9 & 10& 11&\n";
    &fillTable(0);
    print FORMOUT "\\textbf{R.A.}&\\textbf{12h}&\\textbf{13h}&\\textbf{14h}&\\textbf{15h}&\\textbf{16h}","\n","&\\textbf{17h}&\\textbf{18h}&\\textbf{19h}&\\textbf{20h}&\\textbf{21h}&\\textbf{22h}&\\textbf{23h} \\","\\","\n";
    print FORMOUT "\% RA bin & 12& 13& 14& 15& 16& 17& 18& 19& 20& 21& 22& 23&\n";
    &fillTable(36);
    for (my $ia=0; $ia<72; $ia++){
	$totTime = $totTime + $table[$ia];}
    print FORMOUT "\%",$updateTotTime1,"\%",$updateTotTime2,$totTime," hours\n";
    print FORMOUT "\%","for $i sources.\n";
    print              $updateTotTime1,     $updateTotTime2,$totTime," hours\n";
    print              "for $i sources.\n";
    close FORMOUT;
}

sub fillTable{
    # Called by the sub makeTable()
    my $s1=" & "; my $s2=":"; my $s3="\\"; my $hl="\\hline\n";
    my($shift) = @_ ;
    my @minRange;
    $minRange[2]="";$minRange[0]="20-39min$s1";$minRange[1]="40-59min$s1"; 
    print FORMOUT $hl,"00-19min$s1";
    for (my $ib=0; $ib<3; $ib++){
        for (my $ia=$shift+$ib; $ia<(33+$shift+$ib); $ia=$ia+3){
            if ($choice eq 'spaces' && $table[$ia]==0){print FORMOUT " ",$s1;}
	    else                        {print FORMOUT "$table[$ia]",$s1;}
        }
        if ($choice eq 'spaces' && $table[33+$shift+$ib]==0)
            {print FORMOUT " ",$s3,$s3,"\n",$hl,"$minRange[$ib]";}
        else{print FORMOUT $table[33+$shift+$ib],$s3,$s3,"\n",$hl,"$minRange[$ib]";}
    }
}

sub makeList{
    # Creates the LaTex include file for the source list tables
    # To be included in the LaTeX NRT proposal form.
    my $s1=" & "; my $s2=":"; my $s3="\\"; my $hl="\\hline\n";
    my $ib=0;
    open (FORMOUT, '> sourceTable.tex') || die "Problem with output file in sub makeList()";
    print FORMOUT $hl;
    if ($i<13){
	$ib=$i+1;}
    else {
	$ib=13;}
    for (my $ia=1; $ia<$ib; $ia++){
	print FORMOUT $name[$ia],$s1,$rahh[$ia],$s2,$ramm[$ia],$s2,$rass[$ia],$s1,$decdd[$ia],$s2,$decmm[$ia],$s2,$decss[$ia],$s1,$s3,$s3,"\n";
        }
    close FORMOUT;   
    if ($i>=13){
        open (FORMOUT, '> extSourceTable.tex') || die "Problem with output file in sub makeList()";
        for (my $ia=13; $ia<($i+1); $ia++){
	    print FORMOUT $name[$ia],$s1,$rahh[$ia],$s2,$ramm[$ia],$s2,$rass[$ia],$s1,$decdd[$ia],$s2,$decmm[$ia],$s2,$decss[$ia],$s1,$s3,$s3,"\n";
        }
        close FORMOUT;
    }
}

sub fillList{
    # Called by the sub makeList()
    my $s1=" & "; my $s2=":"; my $s3="\\"; my $hl="\\hline\n";
    foreach (@_) {
        for (my $ia=13; $ia<($i+1); $ia++){
	    print FORMOUT $name[$ia],$s1,$rahh[$ia],$s2,$ramm[$ia],$s2,$rass[$ia],$s1,$decdd[$ia],$s2,$decmm[$ia],$s2,$decss[$ia],$s1,$s3,$s3,"\n";
        }
    }
}
